# Dungeon Utility 
[документация](https://github.com/Reider745/libs/blob/main/mod_documentation_api/DungeonUtility.md)

## Сохранение структур

Сохранение структур происходит в несколько этапов:
1. Вызов команды du (включает возможность использовать ванильный деревянный топор для выбора точек!).
2. Выбирите две крайние точки структуры.
3. Выбирите центр структуры, нажав на шифте (желательно).
4. Вызовите команду struct.

### Команда struct
```
/struct save name:string saveAir:bool specialSeparator:bool type:string compression:bool
```
* Параметры команды:
    * name - имя структуры, без пробелов!
    * saveAir - сохранять вместе со структурой блоки воздуха, true или false (указывать не обязательно, по умолчанию false).
    * specialSeparator - красивое оформление JSON, true или false (указывать не обязательно, по умолчанию false).
    * type - тип формата, в который будет сохранена структура (указывать не обязательно, по умолчанию DungeonUtility).
    * compression - сжимать ли структуру с помощью алгоритма Хаффмана, true или false (указывать не обязательно, по умолчанию false).

### Формат DungeonUtility

Родной формат мода, по умолчанию везде используется он, хранит структуры в следующем формате.

Содержит массив с массивами, последний из которых представляет собой информацию о блоке.
Первый элемент массива - строка, которая содержит ID основного блока и дополнительного блока, а также координаты блока (если параметр пустой, то 0).
Второй элемент - строка, которая содержит JSON-представление BlockState основного блока.
Третий элемент - строка, которая содержит JSON-представление BlockState дополнительного блока.
Четвертый элемент - строка, которая содержит JSON-представление CompoundNBT.

```json
[
  ["main_id.extra_id.x.y.z", "{BlockState}", "{BlockState}", "{CompoundNBT}"]
]
```

### Формат Structures

Библиотека - аналог DungeonUtility, в отличие от DungeonUtility поддерживает 1.11 и 1.16.
Поддержка данного формата была добавлена для быстрого перехода с данной библиотекой.

### Формат NBT
[Библиотека](https://github.com/Querz/NBT)

* Другие форматы:
    * DungeonCore
    * Structures
    * DungeonAPI
    * DungeonAPI_V2

| Формат            | Поддержка BlockState | Поддержка дополнительного блока | Поддержка CompountNBT |
|-------------------|----------------------|---------------------------------|-----------------------|
| DungeonUtility_V2 | +                    | +                               | +                     |
| DungeonUtility    | +                    | +                               | +                     |
| DungeonCore       | +                    | +                               | -                     |
| Structures        | -                    | -                               | -                     |
| DungeonUtility    | -                    | -                               | -                     |
| DungeonAPI        | -                    | -                               | -                     |
| DungeonAPI_V2     | -                    | -                               | -                     |
